.PHONY: olsrd olsrd-install olsrd-clean

olsrd: 
	LDFLAGS="${build_ldflags}" \
	CFLAGS="${build_cflags} -Os -I${BUILDDIR}/apps/gpl" \
	CC="${build_toolchain_prefix}gcc" \
	LD="${build_toolchain_prefix}gcc" \
	AR="${build_toolchain_prefix}ar" \
	RANLIB="${build_toolchain_prefix}ranlib" \
	OS="linux" \
	NODEBUG=1 \
	SUBDIRS="bmf dot_draw dyn_gw httpinfo nameservice txtinfo" \
	$(MAKE) -C olsrd all libs

olsrd-clean:
	SUBDIRS="bmf dot_draw dyn_gw httpinfo nameservice txtinfo" \
	$(MAKE) -C olsrd clean clean_libs || echo "Ignoring olsrd-clean errors"

olsrd-install: olsrd
	mkdir -p $(build_install_directory)/sbin/
	cp -f olsrd/olsrd $(build_install_directory)/sbin/
	$(STRIP) $(build_install_directory)/sbin/olsrd
	mkdir -p $(build_install_directory)/usr/etc/init.d/
	cp -f olsrd-additional/olsrd.conf $(build_install_directory)/usr/etc/
	cp -f olsrd-additional/olsrd-init $(build_install_directory)/usr/etc/init.d/olsrd
	mkdir -p $(build_install_directory)/lib/
	cp -f olsrd/lib/dot_draw/olsrd_dot_draw.so.* $(build_install_directory)/lib/
	cp -f olsrd/lib/bmf/olsrd_bmf.so.* $(build_install_directory)/lib/
	cp -f olsrd/lib/dyn_gw/olsrd_dyn_gw.so.* $(build_install_directory)/lib/
	cp -f olsrd/lib/httpinfo/olsrd_httpinfo.so.* $(build_install_directory)/lib/
	cp -f olsrd/lib/nameservice/olsrd_nameservice.so.* $(build_install_directory)/lib/
	cp -f olsrd/lib/txtinfo/olsrd_txtinfo.so.* $(build_install_directory)/lib/
	cp -af $(build_toolchain_dir)/lib/libpthread* $(build_install_directory)/lib/

